
#ifndef threadsinclude
#define threadsinclude


#define	idnullthread		((hdlthread) 0)
#define	idcurrentthread		((hdlthread) 1)
#define	idapplicationthread	((hdlthread) 2)


typedef struct _thread * hdlthread;

typedef void * tythreadmainparams;

typedef pascal void * (*tythreadmaincallback) (tythreadmainparams);

typedef void (*tythreadglobalscallback) (void *);

typedef struct tythreadcallbacks {

	tythreadglobalscallback disposecallback;
	
	tythreadglobalscallback swapincallback;
	
	tythreadglobalscallback swapoutcallback;
	} tythreadcallbacks;

/*globals*/

extern tythreadcallbacks threadcallbacks;


/*prototypes*/

extern boolean canusethreads (void);

extern boolean initmainthread (void *);

extern boolean inmainthread (void);

extern boolean attachtomainthread (long); /*6.2b7 AR*/

extern boolean newthread (tythreadmaincallback, tythreadmainparams, void *, hdlthread *);

extern boolean threadstartup (void);

extern void threadshutdown (void);

extern boolean threadsleep (hdlthread hthread);

extern boolean threadissleeping (hdlthread);

extern boolean threadwake (hdlthread, boolean);

extern boolean threadiswaiting (void);

extern boolean threadyield (boolean);

extern long grabthreadglobals (void);

extern long releasethreadglobals (void);

extern long grabthreadglobalsnopriority (void);

extern long releasethreadglobalsnopriority (void);

extern boolean initthreads (void);

#ifdef fldebug
	extern void checkthreadglobals (void);
#else
	#define checkthreadglobals() ((void *)0)
#endif


#endif
